/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.IProcessRunner;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessRunnable;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.SudoProcessRunnable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SudoManager {
    private static final String DISREGARD_CACHED_CREDENTIALS = "-k";
    private static final String SUDO = "sudo";
    private static final String ECHO = "echo";
    private static final String SUDO_INPUT_PWD = "-S";
    private static final String ECHO_MESSAGE = "SUCCESS";
    private static final String NON_INTERACTIVE = "-n";
    private static final String PASSWORD_PROMPT_FLAG = "-p";
    public static final String END_OF_OPTIONS = "--";
    public static final String RETAIN_HOME = "-H";
    public static final String PROMPT_MSG = "password:";

    public boolean authenticate(char[] password) throws CoreException {
        IStatus status;
        block6: {
            SudoProcessRunnable runnable;
            Process p;
            Map<String, String> environment = ShellExecutable.getEnvironment();
            environment.put("redirectErrorStream", "");
            if (password == null || password.length == 0) {
                password = new char[]{};
                p = this.getProcessRunner().run(environment, SUDO, DISREGARD_CACHED_CREDENTIALS, NON_INTERACTIVE, END_OF_OPTIONS, ECHO, ECHO_MESSAGE);
                runnable = new SudoProcessRunnable(p, null, ECHO_MESSAGE);
            } else {
                p = this.getProcessRunner().run(environment, SUDO, DISREGARD_CACHED_CREDENTIALS, SUDO_INPUT_PWD, PASSWORD_PROMPT_FLAG, PROMPT_MSG, END_OF_OPTIONS, ECHO, ECHO_MESSAGE);
                runnable = new SudoProcessRunnable(p, password, ECHO_MESSAGE);
            }
            status = this.getResult(runnable);
            if (!status.isOK()) break block6;
            return true;
        }
        try {
            IdeLog.logInfo(CorePlugin.getDefault(), status.getMessage());
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e.getMessage());
        }
        catch (InterruptedException e) {
            IdeLog.logWarning((Plugin)CorePlugin.getDefault(), e.getMessage());
        }
        return false;
    }

    protected IStatus getResult(ProcessRunnable runnable) throws InterruptedException {
        Thread t = new Thread((Runnable)runnable, "SudoManager authentication thread");
        t.start();
        t.join();
        IStatus status = runnable.getResult();
        return status;
    }

    protected IProcessRunner getProcessRunner() {
        return new ProcessRunner();
    }

    public List<String> getArguments(char[] sudoPassword) {
        if (PlatformUtil.isWindows()) {
            return Collections.emptyList();
        }
        if (sudoPassword == null || sudoPassword.length == 0) {
            return CollectionsUtil.newList(SUDO, NON_INTERACTIVE, END_OF_OPTIONS);
        }
        return CollectionsUtil.newList(SUDO, PASSWORD_PROMPT_FLAG, PROMPT_MSG, SUDO_INPUT_PWD, END_OF_OPTIONS);
    }
}

